####################################################
### code chunk number : A Real Data Example
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## 
# rt<-read.table("data/commute-times.txt", head=TRUE); rt
rt<-read.table("data/Static-Fatigue-90percent-Stress-Level.txt", head=TRUE); rt
class(rt)
dim(rt)

xx = rt$C1; xx
range(xx)
L_x = length(xx); L_x
n = L_x - 1; n
x = xx[1:n]
x_np1 = xx[n + 1]

## 
## Histogram
## 
dev.new()
col = c("blue")
lty = 1
hist(xx, probability = TRUE, 
    main = paste("Histogram of" , "x"), 
    xlab = "x")
lines(density(xx), lty = lty[1], col = col[1], lwd = 2)
leg.txt = c("Density estimation curve")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Exp-IG_Histogram_x", type = c("pdf"))
savePlot(filename = "figure/Exp-IG_Histogram_x", type = c("jpg"))

# dev.new()
# hist(1/xx)

## 
## Moment estimators
## 
alpha_1_beta_1 = Moment_estimators_EX_EX2(x)
alpha_1 = alpha_1_beta_1[1]; alpha_1
beta_1 = alpha_1_beta_1[2]; beta_1

## KS test
ks_test_1 = ks.test(x, "p_Exp_IG_alpha_Beta", alpha_1, beta_1); ks_test_1

## Compute_Estimators_PESLs
res_moment = Compute_Estimators_PESLs(x = x_np1, alpha = alpha_1, beta = beta_1); res_moment

## Compute the mean and variance of the data
E_V_moment = Compute_E_V_of_X(alpha_1, beta_1); E_V_moment


##
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
##
alpha_2_beta_2 = Newtons(fun = moment_fun, y = alpha_1_beta_1)$root; alpha_2_beta_2
alpha_2 = alpha_2_beta_2[1]; alpha_2
beta_2 = alpha_2_beta_2[2]; beta_2

## KS test
ks_test_2 = ks.test(x, "p_Exp_IG_alpha_Beta", alpha_2, beta_2); ks_test_2

## Compute_Estimators_PESLs
res_MLE = Compute_Estimators_PESLs(x = x_np1, alpha = alpha_2, beta = beta_2); res_MLE

## Compute the mean and variance of the data
E_V_MLE = Compute_E_V_of_X(alpha_2, beta_2); E_V_MLE




